import { createSlice } from "@reduxjs/toolkit";
import { AllFilter } from "../api/api";

interface FilterState {
  data: any;
  status: "idle" | "loading" | "succeeded" | "failed";
  error: string | null;
}

const initialState: FilterState = {
  data: null,
  status: "idle",
  error: null,
};

const filterSlice = createSlice({
  name: "filter",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(AllFilter.pending, (state) => {
        state.status = "loading";
        state.error = null;
      })
      .addCase(AllFilter.fulfilled, (state, action) => {
        state.status = "succeeded";
        state.data = action.payload;
        state.error = null;
      })
      .addCase(AllFilter.rejected, (state, action) => {
        state.status = "failed";
        state.error = action.error.message || "Failed to fetch data.";
      });
  },
});

export default filterSlice.reducer;
