// addressSlice.ts
import { createSlice,  } from '@reduxjs/toolkit';
import { editaddress } from '../api/api';
// Define the type for your address data
interface Address {
  id: string;
  street: string;
  city: string;
  state: string;
  zip: string;
  data:any

}

// Define the initial state type
interface AddressState {
  address: Address | null;
  status: 'idle' | 'loading' | 'succeeded' | 'failed';
  error: string | null;
}

// Define the initial state
const initialState: AddressState = {
  address: null,
  status: 'idle',
  error: null,
};



// Create the slice
const addressSlice = createSlice({
  name: 'address',
  initialState,
  reducers: {
    // Add any additional reducers if needed
  },
  extraReducers: (builder) => {
    builder
      .addCase(editaddress.pending, (state) => {
        state.status = 'loading';
        state.error = null;
      })
      .addCase(editaddress.fulfilled, (state, action) => {
        state.status = 'succeeded';
        state.address = action.payload;
      })
      .addCase(editaddress.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.payload as string;
      });
  },
});

// Export the reducer and actions
export default addressSlice.reducer;
