import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { SallerBuyer, updateProfile } from '../api/api'; 

interface ProfileState {
  sellerProfile: any;
  status: 'idle' | 'loading' | 'succeeded' | 'failed';
  updateStatus: 'idle' | 'loading' | 'succeeded' | 'failed';
  error: string | null;
}

const initialState: ProfileState = {
  sellerProfile: null,
  status: 'idle',
  updateStatus: 'idle',
  error: null,
};

const profileSlice = createSlice({
  name: 'sellerProfile',
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(SallerBuyer.pending, (state) => {
        state.status = 'loading';
      })
      .addCase(SallerBuyer.fulfilled, (state, action: PayloadAction<any>) => {
        state.status = 'succeeded';
        state.sellerProfile = action.payload;
      })
      .addCase(SallerBuyer.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.error.message || 'Failed to load profile';
      })
      .addCase(updateProfile.pending, (state) => {
        state.updateStatus = 'loading';
      })
      .addCase(updateProfile.fulfilled, (state, action: PayloadAction<any>) => {
        state.updateStatus = 'succeeded';
        state.sellerProfile = action.payload; 
      })
      .addCase(updateProfile.rejected, (state, action) => {
        state.updateStatus = 'failed';
        state.error = action.error.message || 'Failed to update profile';
      });
  },
});

export default profileSlice.reducer;
