import { createSlice } from "@reduxjs/toolkit";
import { sellerRegister } from "../api/api";

interface UserRegister {
    isLoading: boolean;
    success: boolean;
    message: string | null;
    error: string | null;
}

const registerSliceSeller = createSlice({
    name: 'register',
    initialState: {
        isLoading: false,
        success: false,
        message: '',
        error: ''
    } as UserRegister,
    reducers: {
    },
    extraReducers: (builder) => {
        builder
            .addCase(sellerRegister.pending, (state) => {
                state.isLoading = true;
                state.error = null;
            })
            .addCase(sellerRegister.fulfilled, (state, action) => {
                state.isLoading = false;
                state.message = action.payload;
            })
            .addCase(sellerRegister.rejected, (state, action) => {
                state.isLoading = false;
                state.error = action.error.message || 'Registration failed';
            });
    }
})

export default registerSliceSeller.reducer;