import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { paymentFailed, } from '../api/api';

interface PaymentState {
 paymentFailedList: any;
  loading: boolean;
  error: string | null;
}

const initialState: PaymentState = {
    paymentFailedList: [],
  loading: false,
  error: null,
};

const paymentSlice = createSlice({
  name: 'payment',
  initialState,
  reducers: {
  },
  extraReducers: (builder) => {
    builder
    .addCase(paymentFailed.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(paymentFailed.fulfilled, (state, action: PayloadAction<any>) => {
        state.loading = false;
        state.paymentFailedList = action.payload;
      })
      .addCase(paymentFailed.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch payment failed listing';
      });
    }
});

// Export the reducer to be used in the store
export default paymentSlice.reducer;
