import { createSlice } from "@reduxjs/toolkit";
import { onGoingBids } from "../api/api";

interface Bids {
  BidsData: any;
  loading: boolean;
  error: string | null;
}

const initialState: Bids = {
    BidsData: null,
  loading: false,
  error: null,
};

const ongoingSlice = createSlice({
  name: "seller",
  initialState,
  reducers: {},
  extraReducers: (builder) => {
    builder
      .addCase(onGoingBids.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(onGoingBids.fulfilled, (state, action) => {
        state.loading = false;
        state.BidsData  = action.payload;
      })
      .addCase(onGoingBids.rejected, (state, action) => {
        state.loading = false;
        state.error = action.payload as string;
      });
  },
});

export default ongoingSlice.reducer;
