
import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface LocationState {
  latitude: string | null;
  longitude: string | null;
  state: string | null;
  country: string | null;
}

const initialState: LocationState = {
  latitude: null,
  longitude: null,
  state: null,
  country: null,
};

const locationSlice = createSlice({
  name: "location",
  initialState,
  reducers: {
    setLocation: (
      state,
      action: PayloadAction<{
        latitude: string;
        longitude: string;
        state: string;
        country: string;
      }>
    ) => {
      state.latitude = action.payload.latitude;
      state.longitude = action.payload.longitude;
      state.state = action.payload.state;
      state.country = action.payload.country;
    },
    clearLocation: (state) => {
      state.latitude = null;
      state.longitude = null;
      state.state = null;
      state.country = null;
    },
  },
});

export const { setLocation, clearLocation } = locationSlice.actions;
export default locationSlice.reducer;
