import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface LocationState {
    messageData: string;
    locationData: string;
    latitudeData: string;
    longitudeData: string;
}

const initialState: LocationState = {
  messageData: "",
  locationData: "",
  latitudeData: "",
  longitudeData: "",
};

const ipAddressSlice = createSlice({
  name: "location",
  initialState,
  reducers: {
    setLocation: (state, action: PayloadAction<LocationState>) => {
      state.messageData = action.payload.messageData;
      state.locationData = action.payload.locationData;
      state.latitudeData = action.payload.latitudeData;
      state.longitudeData = action.payload.longitudeData;
    },
  },
});

export const { setLocation } = ipAddressSlice.actions;
export default ipAddressSlice.reducer;
