import { createSlice, PayloadAction } from '@reduxjs/toolkit';

interface ImageState {
    image: string ;
    letter: string | null;
}

const initialState: ImageState = {
    image: '',
    letter: ''
};

const imageSlice = createSlice({
    name: 'image',
    initialState,
    reducers: {
        setUserImage: (state, action: PayloadAction<string>) => {
            state.image = action.payload;
        },
        setUserLetter: (state, action: PayloadAction<string>) =>{
            state.letter = action.payload;
        },
        clearObjects: (state) =>{
            state.image = ''
            state.letter = ''
        }
    },
});

export const { setUserImage, setUserLetter, clearObjects } = imageSlice.actions;
export default imageSlice.reducer;