import { PayloadAction, createSlice } from "@reduxjs/toolkit";

interface Edit {
    isEdit: boolean;
}

const editSlice = createSlice({
    name: 'edit',
    initialState: {
        isEdit: false,
    } as Edit,
    reducers: {
        setEdit(state, action: PayloadAction<boolean>) {
            state.isEdit = action.payload;
        },
    }
})

export const {setEdit} = editSlice.actions;
export default editSlice.reducer;