import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { fetchAllWishlist } from '../api/api'; // Import all thunks

interface WishlistState {
  data: any; // Ensure data is always an array
  loading: boolean;
  error: string | null;
}

// Initial state
const initialState: WishlistState = {
  data: [],
  loading: false,
  error: null,
};

// Wishlist Slice
const wishlistSlice = createSlice({
  name: 'wishlist',
  initialState,
  reducers: {
    // Define any additional reducers here if needed
  },
  extraReducers: (builder) => {
    builder
      .addCase(fetchAllWishlist.pending, (state) => {
        state.loading = true;
        state.error = null;
      })
      .addCase(fetchAllWishlist.fulfilled, (state, action: PayloadAction<any[]>) => {
        state.loading = false;
        state.data = action.payload;
      })
      .addCase(fetchAllWishlist.rejected, (state, action) => {
        state.loading = false;
        state.error = action.error.message || 'Failed to fetch wishlist';
      });
  },
});

export default wishlistSlice.reducer;
