// components/suspense-wrapper.tsx
"use client";

import { Suspense } from "react";

export default function SuspenseWrapper({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <Suspense
      fallback={
        <div className="w-lvw h-lvh flex justify-center items-center border">
          Loading...
        </div>
      }
    >
      {children}
    </Suspense>
  );
}
