"use client";

import React, { useEffect } from "react";

interface ModalProps {
  isOpen: boolean;
  onClose: () => void;
  title?: string; // Optional title for the modal
  children: React.ReactNode; // Content inside the modal
}

const Modal: React.FC<ModalProps> = ({ isOpen, onClose, title, children }) => {
  // Lock scroll on modal open
  useEffect(() => {
    if (isOpen) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "";
    }

    return () => {
      document.body.style.overflow = "";
    };
  }, [isOpen]);
  if (!isOpen) return null; // Do not render if the modal is closed

  return (
    <div className="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50 my-0">
      <div className="bg-white relative rounded-lg shadow-lg w-full md:3/4 max-h-[33rem] max-w-lg px-2 py-4 md:px-6 overflow-auto mx-2">
        {/* Modal Header */}
        <div className="sticky -top-4 z-40 bg-white flex justify-end">
          <button
            onClick={onClose}
            className="text-black cursor-pointer hover:text-gray-800 text-3xl font-normal p-2"
          >
            &times;
          </button>
        </div>

        {/* </button> */}
        <div className="flex justify-between items-center ">
          {title && (
            <h2 className="text-lg font-bold text-black cursor-pointer">
              {title}
            </h2>
          )}
        </div>
        {/* Modal Content */}
        <div className="mt-4 text-black">{children}</div>
      </div>
    </div>
  );
};

export default Modal;
