import Modal from "../../../bayerProfile/pages/components/modal";

interface LocationModalProps {
  isOpen: boolean;
  onClose: () => void;
  selectedCountry: string;
  selectedState: string | null;
  stateLocationData: any;
  loadings: boolean;
  handleStateChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
}

export default function LocationModal({
  isOpen,
  onClose,
  selectedCountry,
  selectedState,
  stateLocationData,
  loadings,
  handleStateChange,
}: LocationModalProps) {
  return (
    <Modal isOpen={isOpen} onClose={onClose} title={`Select a Location`}>
      {loadings ? (
        <p className="text-black">Loading...</p>
      ) : (
        <form>
          <div className="grid grid-cols-2 gap-4 text-black">
            <label className="flex items-center space-x-2">
              <input
                type="radio"
                name="state"
                value={`All,${
                  selectedCountry === "USA" ? "38.7946,106.5348" : "56.1304,106.3468"
                }`}
                checked={
                  selectedCountry === "CAN"
                    ? selectedState === "Canada"
                    : selectedState === "USA"
                }
                onChange={handleStateChange}
                className="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300"
              />
              <span className="text-black text-start">
                All of {selectedCountry === "CAN" ? "Canada" : "USA"}
              </span>
            </label>
            {stateLocationData?.data?.list.map((state: any) => (
              <label
                key={state.code}
                className="flex items-center space-x-2 cursor-pointer"
              >
                <input
                  type="radio"
                  name="state"
                  value={`${state.name},${state.latitude},${state.longitude}`}
                  checked={selectedState === state.name}
                  onChange={handleStateChange}
                  className="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300"
                />
                <span className="text-black text-start cursor-pointer">
                  {state.name}
                </span>
              </label>
            ))}
          </div>
        </form>
      )}

      {/* <button
        onClick={onClose}
        className="mt-4 px-4 py-1 bg-yellow-500 cursor-pointer text-black rounded"
      >
        Close Modal
      </button> */}
    </Modal>
  );
}