import { RootState } from "../../../../store";
import { useSelector, useDispatch } from "react-redux";
import { getsIncrement } from "../../../../api/api";
import { useEffect } from "react";
export default function IncrementBidInfo() {
  const dispatch = useDispatch<any>();
  const { incrementData } = useSelector(
    (state: RootState) => state.MessageCountReducer
  );
  useEffect(() => {
    dispatch(getsIncrement());
  }, [dispatch]);
  return (
    <div className="py-6">
    <div className="p-6 bg-white rounded-xl border border-gray-100 shadow-sm max-w-7xl mx-auto">
      <div className="flex justify-between items-center mb-6">
        <h2 className="text-2xl font-semibold text-gray-800">Bid Increments</h2>
        <div className="flex items-center space-x-2">
          <span className="text-sm text-gray-500">
            Last updated: {new Date().toLocaleDateString()}
          </span>
        </div>
      </div>

      <div className="overflow-x-auto rounded-lg border border-gray-100">
        <table className="min-w-full divide-y divide-gray-200">
          <thead className="bg-gray-50">
            <tr>
              <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                #
              </th>
              <th className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                Price Range
              </th>
              <th className="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                Increment
              </th>
            </tr>
          </thead>
          <tbody className="bg-white divide-y divide-gray-200">
            {incrementData?.data?.increments.map((item: any, index: number) => (
              <tr key={item.id} className="hover:bg-gray-50 transition-colors">
                <td className="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                  {index + 1}
                </td>
                <td className="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                  <div className="flex items-center">
                    <span className="font-medium">${item.min_price}</span>
                    <span className="mx-2 text-gray-300">-</span>
                    <span>
                      {item.max_price ? `$${item.max_price}` : "Above"}
                    </span>
                  </div>
                </td>
                <td className="px-6 py-4 whitespace-nowrap text-sm text-right">
                  <span className="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                    +${item.increment}
                  </span>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>

      <div className="mt-4 flex justify-between items-center text-sm text-gray-500">
        <div>
          Showing {incrementData?.data?.increments.length || 0} increments
        </div>
        <div className="flex space-x-4">
          <button className="text-gray-500 hover:text-gray-700 disabled:opacity-50">
            Previous
          </button>
          <button className="text-gray-500 hover:text-gray-700 disabled:opacity-50">
            Next
          </button>
        </div>
      </div>
    </div>
    </div>
  );
}
