"use client";

import React from "react";
import profileLocation from "../../../../assets/profileLocation.svg";
import Image from "next/image";

interface CarInfoCardProps {
  avatarUrl: string;
  name: string;
  location: string;
  avgReplies: string;
  daysOnReserveIt: string;
  replyRate: string;
  avgDay: string;
  days: string;
  replyPercentage: string;
  user_id: any;
  view_profile: string;
  showProfile?: boolean;
}

const CarInfoCard: React.FC<CarInfoCardProps> = ({
  avatarUrl,
  name,
  location,
  avgReplies,
  daysOnReserveIt,
  replyRate,
  avgDay,
  days,
  replyPercentage,
  user_id,
  view_profile,
  showProfile = true,
}) => {
  return (
    <div className="bg-white rounded-md p-4 xs:w-full mt-3">
      <div className="flex justify-end gap-4">
        <div className=" flex items-center justify-center  w-24 h-24 lg:h-[144px] lg:w-[144px] rounded-full">
          {avatarUrl ? (
            <Image
              unoptimized
              src={avatarUrl}
              alt="user profile"
              width={144}
              height={144}
              className="w-24 h-24 lg:h-[144px] lg:w-[144px] rounded-full object-cover"
            />
          ) : (
            <div className="w-24 h-24 lg:h-[144px] lg:w-[144px] rounded-full bg-gray-200 flex items-center justify-center text-gray-500 text-sm">
              N/A
            </div>
          )}
        </div>
        <div className="text-center">
          {!showProfile ? (
            <span className="text-black md:text-[1rem] xs:text-sm border rounded-md p-2 opacity-50 cursor-not-allowed">
              {view_profile}
            </span>
          ) : (
            <a
              href={`/seller/${user_id}`}
              className="text-black md:text-[1rem] xs:text-sm border rounded-md p-2 hover:border-yellow-400 hover:text-black"
            >
              {view_profile}
            </a>
          )}
        </div>{" "}
      </div>
      <div className="text-center mt-4 flex flex-col ">
        <h2 className="md:text-3xl xs:text-xl font-bold text-[#3D3D3D] capitalize">
          {name}
        </h2>
        <p className="md:text-lg xs:text-sm flex items-center gap-3 text-[#878787] justify-center pt-1 font-bold">
          {location}
          <Image
            unoptimized
            src={profileLocation}
            alt="Location icon"
            width={18}
            height={18}
          />{" "}
        </p>
      </div>
      <div className="flex justify-around mt-6">
        <div className="text-center flex flex-col border-r-2 w-[100px]">
          <span className="md:text-3xl xs:text-xl font-bold text-black">
            {avgDay}
          </span>
          <span className="text-sm text-black font-bold pt-1">
            {" "}
            {avgReplies}
          </span>
        </div>
        <div className="text-center flex flex-col border-r-2 w-[140px]">
          <span className="md:text-3xl xs:text-xl font-bold text-black">
            {" "}
            {days}
          </span>
          <span className="text-sm text-black font-bold pt-1">
            {" "}
            {daysOnReserveIt}{" "}
          </span>
        </div>
        <div className="text-center flex flex-col border-r-2 w-[100px]">
          <span className="md:text-3xl xs:text-xl font-bold text-black">
            {replyPercentage}
          </span>
          <span className="text-sm text-black font-bold pt-1">{replyRate}</span>
        </div>
      </div>
    </div>
  );
};

export default CarInfoCard;
