"use client";

import {
  FacebookShareButton,
  TwitterShareButton,
  WhatsappShareButton,
  EmailShareButton,
} from "react-share";
import Image from "next/image";
import heart from "../assets/heart.svg";
import likedheart from "../assets/loveHeart.png";
import FacebookIcon from "../assets/facebook.svg";
import WhatsappIcon from "../assets/whatsapp.svg";
import TwitterIcon from "../assets/twitter___.svg";
import EmailIcon from "../assets/email.svg";

interface ShareButtonsProps {
  url: string;
  title: string;
  description: string;
  isProductLiked: boolean;
  onToggleLike: () => void;
}

const ShareButtons = ({
  url,
  title,
  description,
  isProductLiked,
  onToggleLike,
}: ShareButtonsProps) => {
  return (
    <div className="social-icons lg:flex-col md:justify-start gap-5 xs:flex xs:justify-between xs:items-center xs:m-0">
      <div className="social-icon-container">
        <div className="border rounded-full h-[38px] max-w-max p-2 bg-[#E9E9E9] hover:bg-white">
          <FacebookShareButton url={url}>
            {/* <FacebookIcon size={20} round /> */}
            <Image
              unoptimized
              src={FacebookIcon}
              alt="FacebookIcon"
              height={20}
              width={20}
            />
          </FacebookShareButton>
        </div>
      </div>

      <div className="social-icon-container">
        <div className="border rounded-full h-[38px] max-w-max p-2 bg-[#E9E9E9] hover:bg-white">
          <TwitterShareButton url={url} title={title} hashtags={["Auction"]}>
            {/* <TwitterIcon size={20} round /> */}
            <Image
              unoptimized
              src={TwitterIcon}
              alt="TwitterIcon"
              height={20}
              width={20}
            />
          </TwitterShareButton>
        </div>
      </div>

      <div className="social-icon-container">
        <div className="border rounded-full h-[38px] max-w-max p-2 bg-[#E9E9E9] hover:bg-white">
          <WhatsappShareButton url={url} title={title} separator=" - ">
            {/* <WhatsappIcon size={20} round /> */}
            <Image
              unoptimized
              src={WhatsappIcon}
              alt="WhatsappIcon"
              height={20}
              width={20}
            />
          </WhatsappShareButton>
        </div>
      </div>

      <div className="social-icon-container">
        <div className="border rounded-full h-[38px] max-w-max p-2 bg-[#E9E9E9] hover:bg-white">
          <EmailShareButton
            subject={title}
            body={`${description}\n\n${url}`}
            url={url}
          >
            <Image
              unoptimized
              src={EmailIcon}
              alt="EmailIcon"
              height={20}
              width={20}
            />
          </EmailShareButton>
        </div>
      </div>

      {/* Like button */}
      <div className="border rounded-full  max-w-max p-2 bg-[#E9E9E9] hover:bg-white">
        <Image
          unoptimized
          src={isProductLiked ? likedheart : heart}
          alt="like button"
          width={20}
          height={20}
          className="w-5 cursor-pointer object-contain"
          onClick={onToggleLike}
        />
      </div>
    </div>
  );
};

export default ShareButtons;
