// components/About.tsx
"use client";

import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { RootState } from "../store";
import { about } from "../api/api";

function About() {
  const dispatch = useDispatch<any>();
  const data = useSelector((state: RootState) => state.AboutReducer);

  useEffect(() => {
    dispatch(about());
  }, [dispatch]);

  return (
    <>
    <div>
        <h1  className="bg-[#e9e6e6] text-4xl flex justify-center font-bold items-center h-[100px] mb-0">
          About Us
        </h1>
      </div>
    <section
      className="prose prose-sm sm:prose lg:prose-lg prose-slate mx-auto xs:p-3"
      style={{ maxWidth: "1250px" }}
    >
      
      {data?.data?.data?.description ? (
        <div
          className=" max-w-7xl mx-auto text-justify text-black px-4"
          dangerouslySetInnerHTML={{
            __html: data?.data?.data?.description,
          }}
        />
      ) : (
        <div className="text-center py-10">Loading terms...</div>
      )}
    </section>
    </>
  );
}

export default About;
