'use client';

import React, { useState, useEffect } from 'react';

interface ToastProps {
  show: boolean;
  message: string;
  bgColor?: string;
  toasterPosition?: string; // ✅ Allow any valid Tailwind class like 'top-20'
}

const Toast: React.FC<ToastProps> = ({
  show,
  message = '',
  bgColor = 'bg-navy',
  toasterPosition = 'top-10',
}) => {
  const [isVisible, setIsVisible] = useState(show);

  useEffect(() => {
    setIsVisible(show);
    const timer = setTimeout(() => {
      setIsVisible(false);
    }, 3000);

    return () => clearTimeout(timer);
  }, [show]);

  if (!isVisible) return null;

  return (
    <div
      className={`fixed ${toasterPosition} right-10 z-50 text-white px-4 py-2 font-semibold rounded-md shadow-md transition-transform duration-300 ease-in-out ${bgColor}`}
      style={{
        transform: 'translateX(0)',
      }}
    >
      {message}
    </div>
  );
};

export default Toast;
