import React from "react";

type PopupProps = {
  showPopup: boolean;
  message: React.ReactNode;
  onClose: () => void;
  onConfirm: () => void;
  onAddWallet?: () => void; // Optional callback for "Go Add Wallet"
  showAddWalletButton?: boolean; // Show "Add Wallet" button conditionally
};

const Popup: React.FC<PopupProps> = ({
  showPopup,
  message,
  onClose,
  onConfirm,
  onAddWallet,
  showAddWalletButton = false,
}) => {
  if (!showPopup) return null;

  return (
    <div
      className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50"
      role="dialog"
      aria-modal="true"
    >
      <div className="bg-white rounded-lg shadow-lg p-6 lg:w-1/4 xs:w-[90%]  relative">
        {/* Close Button */}
        <button
          onClick={onClose}
          className="absolute top-0 right-3 text-black cursor-pointer hover:text-gray-800 text-4xl font-normal p-0"
          aria-label="Close Popup"
        >
          &times;
        </button>

        {/* Message Section */}
        <div className="text-gray-700 text-center space-y-4 mt-8">
          <div className="text-lg mt-11">{message}</div>
        </div>

        {/* Action Buttons */}
        <div className="flex justify-center space-x-4 mt-6">
          {!showAddWalletButton && (
            <button onClick={onConfirm} className="custom-button">
              Yes
            </button>
          )}
          <button
            onClick={onClose}
            className="bg-gray-300 hover:bg-gray-400 text-gray-800 py-1 px-6 rounded-md"
          >
            No
          </button>
          {showAddWalletButton && onAddWallet && (
            <button onClick={onAddWallet} className="custom-button">
              Add balance
            </button>
          )}
        </div>
      </div>
    </div>
  );
};

export default Popup;
