import React from "react";
import { capitalizeFirstLetter } from "../utils/commonFunction";

interface ChipProps {
  text: "active" | "draft" | "completed" | "scheduled";
}

const statusColors: Record<ChipProps["text"], string> = {
  active: "#249C00",
  draft: "#8F8F8F",
  completed: "#FF3300",
  scheduled: "#0055FE",
};

const Chip: React.FC<ChipProps> = ({ text }) => {
//   console.log;

  return (
    <div
      className={`relative inline-block select-none whitespace-nowrap rounded-lg py-[6px] w-[8rem] items-center font-sans text-xs font-bold leading-none text-white`}
      style={{ backgroundColor: statusColors[text] }}
    >
      <div className="  text-center">{capitalizeFirstLetter(text)}</div>
    </div>
  );
};

export default Chip;
