// app/terms/terms-content.tsx
"use client";

import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { RootState } from "../../store";
import { terms } from "../../api/api";

export default function TermsContent() {
  const dispatch = useDispatch<any>();
  const termsData = useSelector((state: RootState) => state.AboutReducer);

  useEffect(() => {
    dispatch(terms());
  }, [dispatch]);

  return (
    <>
    <div>
        <h1  className="bg-[#e9e6e6] text-4xl flex justify-center font-bold items-center h-[100px] mb-0">
        Terms of Use
        </h1>
      </div>
    <div className="prose prose-sm sm:prose lg:prose-lg prose-slate mx-auto p-3" style={{ maxWidth: "1250px" }}>
      {termsData.termsData?.data?.content ? (
        <div
          className="py-8 mx-auto text-justify text-black px-4"
          dangerouslySetInnerHTML={{
            __html: termsData?.termsData?.data?.content,
          }}
        />
      ) : (
        <div className="text-center py-10 text-black">Loading terms...</div>
      )}
    </div>
    </>
  );
}