"use client";

import { useEffect, useState } from "react";
import wallet from "../../../../assets/wallet.svg";
import { useDispatch, useSelector } from "react-redux";
import { RootState, AppDispatch } from "../../../../store";
import { cashWalletHistory } from "../../../../api/api";
import { formatDate } from "../../../../common/DateFormant";
import Image from "next/image";
// import ConfirmCashInModal from "../../../../components/bayerProfile/pages/components/ConfirmCashInModal";
import dynamic from "next/dynamic";
const ConfirmCashInModal = dynamic(
  () =>
    import(
      "../../../../components/bayerProfile/pages/components/ConfirmCashInModal"
    )
);

const WalletTransactions = () => {
  const [showCashInModal, setShowCashInModal] = useState(false);
  const dispatch: AppDispatch = useDispatch();

  useEffect(() => {
    dispatch(cashWalletHistory());
  }, [dispatch]);

  // Select the necessary data from Redux state
  const { cashWalletHistoryData } = useSelector(
    (state: RootState) => state.WalletReducer
  );

  return (
    <div className="md:p-0 xs:p-4">
      {/* Wallet Balance */}
      <div className="flex flex-col md:flex-row justify-between items-center">
        <div className="flex flex-col items-center space-x-2 bg-white p-5 rounded-md shadow-md">
          <div className="flex items-center gap-1">
            <div className="h-[32px] w-[32px] gap-4 flex align-middle justify-center bg-yellow-400 rounded-full">
              <Image
                unoptimized
                src={wallet}
                alt="Wallet Icon"
                width={14}
                height={12}
              />
            </div>
            <div className="text-[#151D48] text-[32px] font-bold">
              {/* Display the wallet balance */}$
              {cashWalletHistoryData?.wallet_balance || "0.00"}
            </div>
          </div>
          <div>
            <span className="text-[#424242] text-[20px] font-bold">
              Total Amount
            </span>
          </div>
        </div>
        <div className=" flex mt-4 md:mt-0 space-x-4">
          <button
            className="animation-custom-button"
            onClick={() => setShowCashInModal(true)}
          >
            <span className="relative z-10"> Cash In</span>
          </button>
        </div>
      </div>

      {/* Transactions Table */}
      <div className="mt-6">
        <h2 className="text-xl font-semibold text-[#425166] text-start bg-white p-4">
          Wallet Transactions
        </h2>
        <div className="mt-4 bg-white overflow-hidden rounded-md shadow-sm">
          <div className="overflow-y-auto max-h-96 mt-5 mb-10">
            <table className="w-full table-auto border-collapse text-sm text-left">
              <thead className="bg-white sticky top-0 z-10 shadow-sm">
                <tr className="text-[#000] font-medium">
                  <th className="px-4 py-3 border-b border-gray-300 text-nowrap">
                    Transaction ID
                  </th>
                  <th className="px-4 py-3 border-b border-gray-300 text-nowrap">
                    Date & Time
                  </th>
                  <th className="px-4 py-3 border-b border-gray-300 text-nowrap">
                    Transaction Type
                  </th>
                  <th className="px-4 py-3 border-b border-gray-300 text-right text-nowrap">
                    Amount
                  </th>
                  <th className="px-4 py-3 border-b border-gray-300 text-nowrap">
                    Description
                  </th>
                  <th className="sticky top-[-1px] border-t-0 border-r-0 border-b border-l-0 border-b-gray-300 px-4 py-2  bg-white text-nowrap">
                    Status
                  </th>
                </tr>
              </thead>
              <tbody className="divide-y divide-gray-100">
                {cashWalletHistoryData?.transactions?.map(
                  (transaction: any, index: number) => (
                    <tr key={index} className="hover:bg-gray-50">
                      <td className="px-4 py-2 text-center text-[#111827]">
                        {transaction.id || "N/A"}
                      </td>
                      <td className="px-4 py-2 text-[#111827]">
                        {formatDate(transaction.created_at)}
                      </td>
                      <td className="px-4 py-2 capitalize text-[#111827]">
                        {transaction.type}
                      </td>
                      <td className="px-4 py-2 text-right text-[#111827]">
                        ${transaction.amount}
                      </td>
                      <td className="px-4 py-2 capitalize text-[#111827]">
                        {transaction.description}
                      </td>
                      <td className="px-4 py-2 capitalize text-[#111827]">
                        {transaction.status}
                      </td>
                    </tr>
                  )
                )}
              </tbody>
            </table>
          </div>
        </div>
      </div>

      {/* Cash In Modal */}
      {showCashInModal && (
        <ConfirmCashInModal onClose={() => setShowCashInModal(false)} />
      )}

      {/* Cash Out Modal */}
      {/* {showCashOutModal && (
        <ConfirmCashOutModal onClose={() => setShowCashOutModal(false)} />
      )} */}
    </div>
  );
};

export default WalletTransactions;
