

"use client";

import dynamic from "next/dynamic";
import { useEffect, useState } from "react";

const PaymentForm = dynamic(() =>
  import("../../../../components/PaymentForm").then((mod) => mod.PaymentForm)
);

let stripePromise: Promise<any> | null = null;

const WalletPayment = () => {
  const [ElementsComponent, setElementsComponent] = useState<any>(null);
  const [stripe, setStripe] = useState<any>(null);

  useEffect(() => {
    const loadStripeLibs = async () => {
      const stripeJs = await import("@stripe/stripe-js");
      const reactStripeJs = await import("@stripe/react-stripe-js");

      stripePromise = stripeJs.loadStripe(
        process.env.NEXT_PUBLIC_STRIPE_PUBLIC_KEY || ""
      );

      setStripe(await stripePromise);
      setElementsComponent(() => reactStripeJs.Elements);
    };

    loadStripeLibs();
  }, []);

  if (!stripe || !ElementsComponent) return null; // or show a loading indicator

  return (
    <ElementsComponent stripe={stripe}>
      <PaymentForm />
    </ElementsComponent>
  );
};

export default WalletPayment;
