"use client";

import { useState, useEffect } from "react";
import { Notification,  } from "../../../api/api";
import { RootState } from "../../../store";
import { useSelector, useDispatch } from "react-redux";
import { toast } from "react-toastify";

const NotificationSettings = () => {
  const [isEditing, setIsEditing] = useState(false);
  const dispatch = useDispatch<any>();

  const { notification } = useSelector(
    (state: RootState) => state.NotificationReducer
  );
  const { userData } = useSelector((state: RootState) => state.loginReducer);

  const [settings, setSettings] = useState({
    outbid_notification: false,
    auction_notifications: false,
  });

  useEffect(() => {
    if (notification) {
      setSettings({
        outbid_notification: notification?.data?.outbid_notification === "1",
        auction_notifications:
          notification?.data?.auction_notifications === "1",
      });
    }
  }, [notification]);

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    setSettings({ ...settings, [e.target.name]: e.target.checked });
  };

  const toggleEdit = async () => {
    if (isEditing) {
      try {
        const payload = {
          outbid_notification: settings?.outbid_notification ? "1" : "0",
          auction_notifications: settings?.auction_notifications ? "1" : "0",
        };

        const response = await dispatch(Notification(payload)).unwrap();
        if (response.success) {
          toast.success("Notification updated successfully");
        } else {
          toast.error("Failed to update notification");
        }
      } catch {
        alert("Failed to update settings. Please try again.");
      }
    }
    setIsEditing(!isEditing);
  };

  return (
    <div className="mx-auto p-4 ">
      {/* Header Section */}
      <div className="flex justify-between items-center border-b border-gray-300 pb-2 mb-3">
        <h2 className="text-xl sm:text-2xl font-semibold text-black">
          Notification Settings
        </h2>

        <button className="animation-custom-button" onClick={toggleEdit}>
          <span className="relative z-10"> {isEditing ? "Save" : "Edit"}</span>
        </button>
      </div>

      {/* Email Notification */}
      <div className="bg-white p-4 sm:p-5 rounded-md shadow-sm">
        <div className="flex flex-col sm:flex-row sm:items-center sm:space-x-2 mb-4">
          <label className="text-lg font-medium text-black">
            Email notifications:
          </label>
          <p className="text-gray-700 font-semibold text-sm sm:text-base mt-1 sm:mt-0">
            {userData?.data?.user?.email || "N/A"}
          </p>
        </div>

        {/* Outbid Notification */}
        <label className="flex items-start sm:items-center space-x-2 text-gray-700 mt-3">
          <input
            type="checkbox"
            name="outbid_notification"
            checked={settings.outbid_notification}
            onChange={handleChange}
            disabled={!isEditing}
            className="h-4 w-4 mt-1 sm:mt-0 text-blue-600"
          />
          <span className="text-sm sm:text-base text-black">
            Receive email notifications when you get outbid.
          </span>
        </label>
      </div>

      {/* Auction Notification */}
      <label className="flex items-start sm:items-center space-x-2 text-gray-700 bg-white p-4 sm:p-5 mt-3 rounded-md shadow-sm">
        <input
          type="checkbox"
          name="auction_notifications"
          checked={settings.auction_notifications}
          onChange={handleChange}
          disabled={!isEditing}
          className="h-4 w-4 mt-1 sm:mt-0 text-blue-600"
        />
        <span className="text-sm sm:text-base text-black">
          Receive upcoming auction notifications.
        </span>
      </label>
    </div>
  );
};

export default NotificationSettings;
