"use client";

import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { RootState } from "../../store";
import { polices } from "../../api/api";
import parse from "html-react-parser";

function Privacy() {
  const dispatch = useDispatch<any>();
  const termsData = useSelector((state: RootState) => state.AboutReducer);
  useEffect(() => {
    dispatch(polices());
  }, [dispatch]);
  return (
    <>
     <div>
        <h1  className="bg-[#e9e6e6] text-4xl flex justify-center font-bold items-center h-[100px] mb-0">
        Privacy Policy
        </h1>
      </div>
    <div
      className="prose prose-sm sm:prose lg:prose-lg prose-slate  mx-auto p-3"
      style={{ maxWidth: "1250px" }}
    >
      {termsData.policeData?.data?.content ? (
        <div className="py-8 max-w-7xl mx-auto text-justify text-black">
          {parse(termsData?.policeData?.data?.content)}
        </div>
      ) : (
        <div className="text-center py-10 text-black">Loading terms...</div>
      )}
    </div>
    </>
  );
}

export default Privacy;
