// app/not-found.tsx
import { Suspense } from "react";
import PageNotFound from "../../public/not-found.png";
import Image from "next/image";

export default function NotFound() {
  return (
    <Suspense fallback={<div>Loading...</div>}>
      <NotFoundContent />
    </Suspense>
  );
}

function NotFoundContent() {
  // Your actual 404 page content here
  return (
    <div className="flex flex-col items-center justify-center gap-4">
      <Image
        unoptimized
        src={PageNotFound}
        alt="page-not-found"
        className="h-[400px] w-[500px]"
      ></Image>
      {/* <h1>404 - Page Not Found</h1>
      <p>The page you're looking for doesn't exist.</p> */}
    </div>
  );
}
