import "../styles/globals.css";
// import Footer from "../common/footer";
import type { Metadata } from "next";
import { ReactNode } from "react";
import ReduxProvider from "../providers/ReduxProvider";
import SuspenseWrapper from "../components/suspense-wrapper";
// import ClientToastWrapper from "../components/ClientToastWrapper";
const ClientToastWrapper = dynamic(
  () => import("../components/ClientToastWrapper")
);
import { inter, oxygen } from "./fonts";
import dynamic from "next/dynamic";
// import Header from "../common/header";
// import Footer from "../common/footer";

const Header = dynamic(() => import("../common/header"));
const Footer = dynamic(() => import("../common/footer"));

export const metadata: Metadata = {
  icons: {
    icon: "/favicon.svg",
  },
  title: "Reservitt",
};

export default function RootLayout({ children }: { children: ReactNode }) {
  return (
    <html lang="en" className={`${inter.variable} ${oxygen.variable}`}>
      <body className="bg-[#F8F9F9] font-sans">
        <ReduxProvider>
          <SuspenseWrapper>
            <div className="flex flex-col min-h-screen">
              <Header />
              <main className="flex-grow">{children}</main>
              <Footer />
            </div>
            <ClientToastWrapper />
          </SuspenseWrapper>
        </ReduxProvider>
      </body>
    </html>
  );
}
