// src/api/Listing.ts
import { axiosRequest } from "./api"; // ✅ Correct relative path
import { BUYER_GET_AUCTION_VIEW_LISTING_URL } from "../constants";

export async function getListingById(id: string, user_id?: string) {
  try {
    const url = `${BUYER_GET_AUCTION_VIEW_LISTING_URL}/${id}${
      user_id ? `?user_id=${user_id}` : ""
    }`;
    const response = await axiosRequest(url, "GET", "", true);
    return response?.data;
  } catch {
    return null;
  }
}
